package cz.drg.clasificator.writers;

import cz.drg.clasificator.util.HeaderList;
import java.util.List;

/**
 * Class used to write data to some outside location. Could be file, database,
 * standard output or something else.
 * 
 * @author Pavel Jirasek
 */
public interface OutputWriter {

    /**
     * Concatenates the original data and the evaluated data from the application
     * and writes them to some outside location.
     * 
     * @param originalInput
     * @param evaluatedOutput 
     */
    public void writeOutput(HeaderList originalInput, List<List<String>> evaluatedOutput);

    /**
     * Writes them to some outside location.
     * 
     * @param lines 
     */
    public void writeOutput(List<String> lines);
    
    /**
     * Clears target destination of any data that previously existed there.
     */
    public void clear();
    
    /**
     * Finalize everything that was used in the reader. Close streams, connections, etc.
     */
    public void close();
    
}
